/* rejprob.prg: Program that computes the empirical rejection probabilites
    for various test procedures. */
/* Last revised by M. Yogo (7/20/04) */

format /m1 /rdn 3,3;

load DFbelt=Dfbelt;
load DFGLSbelt=DfGLSbelt;
load Qconf=Qconf;
load Qconf1=Qconf1;
load Qconfols=Qconfols;
load uscaleu=uscaleu;
load uscales1=uscales1;
load uscales2=uscales2;
load tquantL=tquantL;
load tquantR=tquantR;
load tconf=tconf;
load tconfgls=tconfgls;


/* Conventional critical value of t-test */

zcrit = cdfni(.95);

/* Maximum lag length for BIC */

maxp = 5;

/* Degrees of freedom for t-distribution (normal if dof<=0) */

sample=rows(ret);

{conf,beta,alphahat} = predtest(ret,pred,maxp);


                    urind=(conf[9]<-4.50*sqrt(rows(ret)));
                    bontlower=beta[3];
                    bontupper=beta[4];
                    print "deltahat=" conf[2];
                    print "";
                    print "DF-OLS=" conf[3];
                    print "DF-GLS=" conf[4];
                    print "";
                    print "standard-t=" beta[1];
                    print "";
                    print "|Thetahat|=" alphahat;
                    print "DF-NB=" conf[9];
                    print "DF-NB Critical Value=" -4.50*sqrt(rows(ret));
                    print "";
                    print "Lower Bound Beta t-OLS=" beta[3];
                    print "Upper Bound Beta t-OLS=" beta[4];
                    print "Lower Bound Beta t-GLS=" beta[5];
                    print "Upper Bound Beta t-GLS=" beta[6];
                    print "Lower Bound Beta Q-OLS=" beta[17];
                    print "Upper Bound Beta Q-OLS=" beta[18];
                    print "Lower Bound Beta Q-GLS=" beta[11];
                    print "Upper Bound Beta Q-GLS=" beta[12];
                    print "";                   
                                     
                    
                    

                   
                  {conf,beta} = predtestunion(ret,pred,maxp,uscaleu);
                   if urind>0;
                   unionrej=beta[1]-zcrit;
                   else;
                   if conf[2]<0;
                   unionrej=maxc(beta[3]|beta[9]);
                   else;
                   unionrej=bontlower;
                   endif;
                   endif;

                   print "Lower Bound Beta U^hyb=" unionrej;

                   if urind>0;
                   unionrej=beta[1]+zcrit;
                   else;
                   if conf[2]<0;
                   unionrej=bontupper;
                   else;
                   unionrej=minc(beta[4]|beta[10]);
                   endif;
                   endif;

                   print "Upper Bound Beta U^hyb=" unionrej;

                   {conf,beta} = predtestunion(ret,pred,maxp,uscales1);
                   
                   lambdascale=exp(-1*alphahat);
                   switchbeta=((1-lambdascale)*beta[3])+(lambdascale*beta[9]);
                       
                   if urind>0;
                   switchrej=beta[1]-zcrit;
                   else;
                   if conf[2]<0;
                   switchrej=switchbeta;
                   else;
                   switchrej=bontlower;
                   endif;
                   endif;

                   print "Lower Bound Beta W_1^hyb=" switchrej;

                   switchbeta=((1-lambdascale)*beta[4])+(lambdascale*beta[10]);
    
                   if urind>0;
                   switchrej=beta[1]+zcrit;
                   else;
                   if conf[2]<0;
                   switchrej=bontupper;
                   else;
                   switchrej=switchbeta;
                   endif;
                   endif;

                   print "Upper Bound Beta W_1^hyb=" switchrej;

                   {conf,beta} = predtestunion(ret,pred,maxp,uscales2);
                   
                   lambdascale=exp(-2*alphahat);
                   switchbeta=((1-lambdascale)*beta[3])+(lambdascale*beta[9]);
    
                   if urind>0;
                   switchrej2=beta[1]-zcrit;
                   else;
                   if conf[2]<0;
                   switchrej2=switchbeta;
                   else;
                   switchrej2=bontlower;
                   endif;
                   endif;

                   print "Lower Bound Beta W_2^hyb=" switchrej2;

                   switchbeta=((1-lambdascale)*beta[4])+(lambdascale*beta[10]);
    
                   if urind>0;
                   switchrej2=beta[1]+zcrit;
                   else;
                   if conf[2]<0;
                   switchrej2=bontupper;
                   else;
                   switchrej2=switchbeta;
                   endif;
                   endif;

                   print "Upper Bound Beta W_2^hyb=" switchrej2;

#include bic.prg;
#include predtestfinal.prg; 
#include predtestunion.prg;
#include dfnbbic.prg;

#include Lconf.prg;
#include Uconf.prg;
#include BonLconf.prg;
#include BonUconf.prg;

#include Lcrit.prg;
#include Rcrit.prg;
#include BonLcrit.prg;
#include BonRcrit.prg;
